const form = document.getElementById("form");
const nameInput = document.getElementById("name");
const email = document.getElementById("email");
const phone = document.getElementById("phone");
const size = document.getElementById("size");
const crust = document.getElementById("crust");
const address = document.getElementById("address");
const time = document.getElementById("time");
const terms = document.getElementById("terms");
const toppingElems = document.getElementsByName("topping");

let isValid = true;

form.addEventListener("submit", (e) => {
  e.preventDefault();
  if (validateInputs()) {
    // On success, show a friendly confirmation and clear the form 
    alert("Order placed successfully! Thank you.");
    form.reset();
    // Optionally redirect to a confirmation page:
    // window.location.href = "order-confirmation.html";
  } else {
    console.log("form did not submit due to validation errors");
  }
});

const setError = (element, message) => {
  const inputControl = element.parentElement;
  const errorDisplay = inputControl.querySelector(".error");

  if (errorDisplay) errorDisplay.innerText = message;
  inputControl.classList.add("error");
  inputControl.classList.remove("success");
  isValid = false;
};

const setSuccess = (element) => {
  const inputControl = element.parentElement;
  const errorDisplay = inputControl.querySelector(".error");

  if (errorDisplay) errorDisplay.innerText = "";
  inputControl.classList.add("success");
  inputControl.classList.remove("error");
};

const isValidEmail = (emailVal) => {
  const re = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,6}$/;
  return re.test(String(emailVal).toLowerCase());
};

const isValidPhone = (phoneVal) => {
  const re = /^[0-9]{10}$/;
  return re.test(phoneVal);
};

const validateInputs = () => {
  isValid = true;

  const nameValue = nameInput.value.trim();
  const emailValue = email.value.trim();
  const phoneValue = phone.value.trim();
  const sizeValue = size.value.trim();
  const crustValue = crust.value.trim();
  const addressValue = address.value.trim();
  const timeValue = time.value.trim();

  if (nameValue === "") {
    setError(nameInput, "Name is required");
  } else if (nameValue.length < 3) {
    setError(nameInput, "Enter at least 3 characters for name");
  } else {
    setSuccess(nameInput);
  }

  if (emailValue === "") {
    setError(email, "Email is required");
  } else if (!isValidEmail(emailValue)) {
    setError(email, "Provide a valid email address");
  } else {
    setSuccess(email);
  }

  if (phoneValue === "") {
    setError(phone, "Phone number is required");
  } else if (!isValidPhone(phoneValue)) {
    setError(phone, "Provide a valid 10-digit phone number");
  } else {
    setSuccess(phone);
  }

  if (sizeValue === "") {
    setError(size, "Select a pizza size");
  } else {
    setSuccess(size);
  }

  if (crustValue === "") {
    setError(crust, "Select a crust type");
  } else {
    setSuccess(crust);
  }

  // check toppings - at least one selected
  let toppingChecked = false;
  for (let t of toppingElems) {
    if (t.checked) {
      toppingChecked = true;
      break;
    }
  }
  if (!toppingChecked) {
    // show error under the first checkbox container
    const el = toppingElems[0].closest(".input-control") || toppingElems[0].parentElement;
    setError(el, "Select at least one topping");
  } else {
    const el = toppingElems[0].closest(".input-control") || toppingElems[0].parentElement;
    setSuccess(el);
  }

  if (addressValue === "") {
    setError(address, "Delivery address is required");
  } else {
    setSuccess(address);
  }

  if (timeValue === "") {
    setError(time, "Choose a delivery time");
  } else {
    setSuccess(time);
  }

  if (!terms.checked) {
    setError(terms, "Please accept terms to continue");
  } else {
    setSuccess(terms);
  }

  return isValid;
};
